/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.AttendanceTotalAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.part.PartManager;

import jp.mosp.kintai.dao.CmRotationDao;
import jp.mosp.kintai.dto.CmRotationDto;
import jp.mosp.kintai.dto.MScheduleDto;
import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.ScheduleInputCardVo;

public class ScheduleInputCardAction extends AttendanceTotalAction {

	// R}h
	private static final String CMD_INPUT_CARD_SHOW	= "K1220";
	private static final String CMD_INPUT_CARD_REGIST	= "K1221";

	/**
	 * RXgN^
	 */
	public ScheduleInputCardAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// VO̎擾yѐݒ
		ScheduleInputCardVo vo = new ScheduleInputCardVo();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[h̏
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾		
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// Ώ۔N擾
		Date targetMonth = util.getSystemDate();
		// v_ẼZbg
		setPulldownList(vo, targetMonth);
		/*						
		 *  	2008/11/14	m.yoshida	I\
		 */
		// ΏێЈݒ
		vo.setSelectKCode(mKihon.getKCode());
		// l{̎擾
		setSelectBasicInfo(vo);
		// R}h̏
		if (cmd.equals(CMD_INPUT_CARD_SHOW)) {
			// \
			// Ώ۔Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(targetMonth)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(targetMonth)));
			vo.setPltScheduleDay(String.valueOf(MospUtility.getDay(targetMonth)));
			// Ώۓݒ
			vo.setPltRotationDays("1");
		} else if (cmd.equals(CMD_INPUT_CARD_REGIST)) {
			vo.setParams(request);
			// o^i擾j
			int number = regist(vo);
			// R~bg
			commit();
			// bZ[Wݒ
			request.setAttribute(MospConst.ATT_MESSAGE, 
					MospUtility.getMessage(msg, CommonConst.MSG_NUMBER_OF_UPDATES, String.valueOf(number))
			);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * v_ẼZbg
	 * @param vo
	 * @param targetMonth
	 * @throws Exception
	 */
	private void setPulldownList(ScheduleInputCardVo vo,Date targetMonth) throws Exception {
		// JnÑv_E
		vo.aryPltScheduleYear	= util.getYearArray(MospUtility.getYear (targetMonth), 0, 1);
		vo.aryPltScheduleMonth	= util.getMonthArray();
		vo.aryPltScheduleDay	= util.getDayArray();
		// Ζp^[v_E
		CmRotationDao cmRotationDao = new CmRotationDao();
		cmRotationDao.initDao(cfg, cmd, aspUser, user, conn);
		List<CmRotationDto> listRotation = cmRotationDao.findForCondition(mKihon.getKCode());
		vo.aryPltRotation = new String[listRotation.size()][2];
		for (int i = 0; i < vo.aryPltRotation.length; i++) {
			vo.aryPltRotation[i][0] = listRotation.get(i).getRtCode();
			vo.aryPltRotation[i][1] = listRotation.get(i).getRtName();
		}
		// v_E̔z
		vo.aryPltDays = util.getDayArray();
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// Ζ`
		vo.aryPltWorkType = getWorkTypeArrayNotDeleted();
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.aryPltWorkType.length == 0) {
			vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * o^
	 * @param vo
	 * @throws Exception
	 */
	private int regist(ScheduleInputCardVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// p[^̑ÓmF
		vo.validate();
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// JnEI
		Date startDate;
		Date endDate;
		// ʏTxo^tO
		boolean isWeekHoliday = false;
		// JnEIݒ
		if (vo.getCkbSelectPeriod().equals(CommonConst.NAM_COMMON_FLAG_OFF)) {
			/*						
			 *  	2009/01/20	m.yoshida	ߓΉ
			 */
			startDate = getStartDateForList(util.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth()));
			endDate = getEndDateForList(util.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth()));
			isWeekHoliday = true;
		} else {
			startDate = util.getDate(vo.getPltYear(), vo.getPltMonth(), vo.getPltScheduleDay());
			endDate = util.addDay(startDate, vo.getIntParam(vo.getPltRotationDays()) -1);
		}
		/*						
		 *  	2008/11/14	m.yoshida	\o^@\ǉΉ
		 */
		// Ζp^[̋Ζ`ԂƏjՓtO擾
		boolean isPublicHoliday = isPublicHoliday(vo.getCkbSelectWorkType(), vo.getPltRotationCode());
		// Αӏݒ
		setCalcParam();
		// JnAIݒ
		super.startDate = MospUtility.getDateString(startDate, CommonConst.FORMAT_DATE);
		super.endDate = MospUtility.getDateString(endDate, CommonConst.FORMAT_DATE);
		// oΕ̎擾Ə
		getAttendanceList(mKihon.getKCode());
		// zɓtƋΖ`ԃR[hZbg
		String[][] aryScheduleList = makeScheduleList(
				getAryRotation(vo.getCkbSelectWorkType(), vo.getPltRotationCode(), vo.getPltWorkTypeCode()),
				isPublicHoliday,
				isWeekHoliday
		);
		// XVEo^
		int number = 0;
		// oἘt̎擾
		Date[] attendanceDate = null ;
		if (attendanceList.size() != 0) {
			attendanceDate = new Date[attendanceList.size()];
			for (int k = 0; k < attendanceList.size(); k++) {
				attendanceDate[k] = MospUtility.getDate(attendanceList.get(k).getHizuke());
			}
		}
		// XPW[o^
		for (int i = 0; i < aryScheduleList.length; i++) {
			// Ζ`ԂftHg̒l擾A\DTOɃZbg
			if (aryScheduleList[i][1].equals("")) {
				continue;
			}
			MScheduleDto registScheduleDto = setScheduleInfo(
					mKihon,
					aryScheduleList[i]
			);
			// XPW[̓t擾
			Date scheduleDate = MospUtility.getDate(aryScheduleList[i][0]);
			// toΕ
			if (chkExistObject(attendanceDate)) {
				// oΊmF
				boolean isAttendance = false;
				for (int m = 0; m < attendanceDate.length; m++) {
					if (attendanceDate[m].compareTo(scheduleDate) == 0) {
						isAttendance = true;
						break;
					}
				}
				if (isAttendance) {
					// oΕɊɓo^Ăꍇ͗\̂ݍXV
					registSchedule(registScheduleDto, vo);
					number++;
				} else {
					// oΕƗ\\ɓlo^
					MSyukkinboDto insertSyukkinboDto = copyScheduleInfo(registScheduleDto);
					// oΕɓo^
					insert(insertSyukkinboDto, vo);
					// \ɓo^
					registSchedule(registScheduleDto, vo);
					number++;
				}
			} else {
				// oΕ냊Xgꍇ
				// oΕƗ\\ɓlo^
				MSyukkinboDto insertSyukkinboDto = copyScheduleInfo(registScheduleDto);
				// oΕɓo^
				insert(insertSyukkinboDto, vo);
				// \ɓo^
				registSchedule(registScheduleDto, vo);
				number++;
			}
		}
		// Zbg
		return number;
	}

	/**
	 * XPW[z
	 * <p>	2008/11/14	m.yoshida	\o^@ǉΉ	</p>
	 * @param startDate			JnN
	 * @param endDate			IN
	 * @param aryRotation 		Ζp^[z
	 * @param isPublicHoliday 	jՓtO
	 * @param isWeekHoliday		ʏTxo^tO
	 * @return@arySchedule		\o^pz
	 * @throws Exception
	 */
	private String[][] makeScheduleList(
			String[] aryRotation,
			boolean isPublicHoliday,
			boolean isWeekHoliday
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(util.convStringDateToDate(startDate));
		// ̐ݒ
		int count = 0;
		while (util.convStringDateToDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z̏
		String[][] arySchedule = new String[count][2];
		for (int i = 0; i < arySchedule.length; i++) {
			arySchedule[i][0] = "";
			arySchedule[i][1] = "";
		}
		// tݒ
		cal.setTime(util.convStringDateToDate(startDate));
		int irotate = 0;
		int max = aryRotation.length -1;
		for (int i = 0; i < arySchedule.length; i++) {
			if (irotate > max) {
				irotate = 0;
			}
			// Ζp^[̃[e[V
			while (aryRotation[irotate].equals("")) {
				irotate ++;
				if (irotate > max) {
					irotate = 0;
				}
			}
			// t
			arySchedule[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// Ζ`ԃR[h
			String workTypeCode = aryRotation[irotate];
			// jՓtO
			if (getPublicHolidayName(cal.getTime()).length() != 0 && isPublicHoliday) {
				workTypeCode = "";
			}
			// `FbN
			if (isWeekHoliday) {
				if (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY
						|| cal.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY
				) {
					workTypeCode = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
				}
			}
			arySchedule[i][1] = workTypeCode;
			irotate++;
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		return arySchedule;
	}

	/**
	 * Ώۗ֔Ԕz
	 * @param ckbSelect		ΏۑI@\
	 * @param pltRotation	ΏۑI֔ԃR[h
	 * @param pltWorkType	ΏۑIΖ`ԃR[h
	 * @return
	 * @throws Exception
	 */
	private String[] getAryRotation(String ckbSelect, String pltRotation, String pltWorkType) throws Exception {
		if (ckbSelect.equals(CommonConst.NAM_COMMON_FLAG_ON)) {
			return PartManager.rotation(partInfo()).getRotationArray(pltRotation);
		} else {
			return new String[]{pltWorkType};
		}	
	}

	/**
	 * jՓtO
	 * @param ckbSelect		ΏۑI@\
	 * @param pltRotation	ΏۑI֔ԃR[h
	 * @return
	 * @throws Exception
	 */
	private boolean isPublicHoliday(String ckbSelect, String pltRotation) throws Exception {
		if (ckbSelect.equals(CommonConst.NAM_COMMON_FLAG_ON)) {
			return PartManager.rotation(partInfo()).getPublicHolidayFlag(pltRotation);
		} else {
			return true;
		}
	}

}
